/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import java.util.Objects;
import java.util.UUID;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.User;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VerboseCheckTarget {
    public static final String USER_TYPE = "user";
    public static final String GROUP_TYPE = "group";
    public static final String INTERNAL_TYPE = "internal";
    private final String type;
    private final String name;
    private final UUID id;
    private final String desc;

    public static VerboseCheckTarget user(User user) {
        return new VerboseCheckTarget(USER_TYPE, user.getPlainDisplayName(), user.getUniqueId());
    }

    public static VerboseCheckTarget group(Group group) {
        return new VerboseCheckTarget(GROUP_TYPE, group.getPlainDisplayName(), null);
    }

    public static VerboseCheckTarget internal(String name) {
        return new VerboseCheckTarget(INTERNAL_TYPE, name, null);
    }

    public static VerboseCheckTarget of(String type, String name) {
        return new VerboseCheckTarget(type, name, null);
    }

    private VerboseCheckTarget(String type, String name, UUID id) {
        this.type = type;
        this.name = name;
        this.id = id;
        this.desc = this.type.equals(USER_TYPE) ? this.name : this.type + '/' + this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable UUID getId() {
        return this.id;
    }

    public String describe() {
        return this.desc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerboseCheckTarget that = (VerboseCheckTarget)o;
        return this.type.equals(that.type) && this.name.equals(that.name) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.id);
    }

    public String toString() {
        return "VerboseCheckTarget{type=" + this.type + ", name=" + this.name + ", id=" + this.id + '}';
    }
}

