/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.types;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.cache.PatternCache;
import me.lucko.luckperms.common.node.AbstractNode;
import me.lucko.luckperms.common.node.AbstractNodeBuilder;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import net.luckperms.api.node.types.RegexPermissionNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegexPermission
extends AbstractNode<RegexPermissionNode, RegexPermissionNode.Builder>
implements RegexPermissionNode {
    public static final String MARKER_1 = "r=";
    public static final String MARKER_2 = "R=";
    private final String pattern;
    private final Cache<PatternCache.CachedPattern> cache = new Cache<PatternCache.CachedPattern>(){

        @Override
        protected @NonNull PatternCache.CachedPattern supply() {
            return PatternCache.lookup(RegexPermission.this.pattern);
        }
    };

    public static String key(String pattern) {
        return MARKER_1 + pattern;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RegexPermission(String pattern, boolean value, long expireAt, ImmutableContextSet contexts, Map<NodeMetadataKey<?>, Object> metadata) {
        super(RegexPermission.key(pattern), value, expireAt, contexts, metadata);
        this.pattern = pattern;
    }

    @Override
    public @NonNull String getPatternString() {
        return this.pattern;
    }

    @Override
    public @NonNull Optional<Pattern> getPattern() {
        return Optional.ofNullable(this.cache.get().getPattern());
    }

    @Override
    public @NonNull Builder toBuilder() {
        return new Builder(this.pattern, this.value, this.expireAt, this.contexts, this.metadata);
    }

    public static @Nullable Builder parse(String key) {
        if (!key.startsWith(MARKER_1) && !key.startsWith(MARKER_2)) {
            return null;
        }
        return RegexPermission.builder().pattern(key.substring(2));
    }

    public static final class Builder
    extends AbstractNodeBuilder<RegexPermissionNode, RegexPermissionNode.Builder>
    implements RegexPermissionNode.Builder {
        private String pattern;

        private Builder() {
            this.pattern = null;
        }

        public Builder(String pattern, boolean value, long expireAt, ImmutableContextSet context, Map<NodeMetadataKey<?>, Object> metadata) {
            super(value, expireAt, context, metadata);
            this.pattern = pattern;
        }

        @Override
        public @NonNull Builder pattern(@NonNull String pattern) {
            Objects.requireNonNull(pattern, "pattern");
            if (pattern.isEmpty()) {
                throw new IllegalArgumentException("pattern is empty");
            }
            this.pattern = pattern;
            return this;
        }

        @Override
        public @NonNull Builder pattern(@NonNull Pattern pattern) {
            return this.pattern(Objects.requireNonNull(pattern, "pattern").pattern());
        }

        @Override
        public @NonNull RegexPermission build() {
            Builder.ensureDefined(this.pattern, "pattern");
            return new RegexPermission(this.pattern, this.value, this.expireAt, this.context.build(), this.metadata);
        }
    }
}

