/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.serializer;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.MutableContextSetImpl;
import net.luckperms.api.context.ContextSet;

public final class ContextSetJsonSerializer {
    private ContextSetJsonSerializer() {
    }

    public static JsonObject serialize(ContextSet contextSet) {
        JsonObject output = new JsonObject();
        ArrayList<Map.Entry<String, Set<String>>> entries = new ArrayList<Map.Entry<String, Set<String>>>(contextSet.toMap().entrySet());
        entries.sort(Map.Entry.comparingByKey());
        block4: for (Map.Entry entry : entries) {
            Object[] values = ((Set)entry.getValue()).toArray(new String[0]);
            switch (values.length) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    output.addProperty((String)entry.getKey(), (String)values[0]);
                    continue block4;
                }
            }
            Arrays.sort(values);
            JsonArray arr = new JsonArray();
            for (Object value : values) {
                arr.add((JsonElement)new JsonPrimitive((String)value));
            }
            output.add((String)entry.getKey(), (JsonElement)arr);
        }
        return output;
    }

    public static ContextSet deserialize(Gson gson, String input) {
        Objects.requireNonNull(input, "input");
        if (input.equals("{}")) {
            return ImmutableContextSetImpl.EMPTY;
        }
        JsonObject jsonObject = (JsonObject)gson.fromJson(input, JsonObject.class);
        if (jsonObject == null) {
            return ImmutableContextSetImpl.EMPTY;
        }
        return ContextSetJsonSerializer.deserialize((JsonElement)jsonObject);
    }

    public static ContextSet deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject jsonObject = element.getAsJsonObject();
        Set entries = jsonObject.entrySet();
        if (entries.isEmpty()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        MutableContextSetImpl contextSet = new MutableContextSetImpl();
        for (Map.Entry entry : entries) {
            String k = (String)entry.getKey();
            JsonElement v = (JsonElement)entry.getValue();
            if (v.isJsonArray()) {
                JsonArray values = v.getAsJsonArray();
                for (JsonElement value : values) {
                    contextSet.add(k, value.getAsString());
                }
                continue;
            }
            contextSet.add(k, v.getAsString());
        }
        return contextSet;
    }
}

