/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import me.lucko.luckperms.common.context.AbstractContextSet;
import me.lucko.luckperms.common.context.ContextImpl;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSatisfyMode;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.context.MutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MutableContextSetImpl
extends AbstractContextSet
implements MutableContextSet,
ContextSet {
    private final SetMultimap<String, String> map;

    public MutableContextSetImpl() {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    }

    MutableContextSetImpl(SetMultimap<String, String> other) {
        this.map = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create(other));
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public @NonNull ImmutableContextSet immutableCopy() {
        if (this.map.isEmpty()) {
            return ImmutableContextSetImpl.EMPTY;
        }
        Object[] arr = this.toArray();
        Arrays.sort(arr);
        return new ImmutableContextSetImpl((Context[])arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull MutableContextSetImpl mutableCopy() {
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            return new MutableContextSetImpl(this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ImmutableSet<Context> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set entries = this.map.entries();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : entries) {
                builder.add((Object)new ContextImpl((String)e.getKey(), (String)e.getValue()));
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Map<String, Set<String>> toMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map map = this.map.asMap();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : map.entrySet()) {
                builder.put((Object)((String)e.getKey()), (Object)ImmutableSet.copyOf((Collection)((Collection)e.getValue())));
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public @NonNull Map<String, String> toFlattenedMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set entries = this.map.entries();
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            for (Map.Entry e : entries) {
                builder.put((Object)((String)e.getKey()), (Object)((String)e.getValue()));
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context[] toArray() {
        Context[] array;
        SetMultimap<String, String> setMultimap = this.map;
        synchronized (setMultimap) {
            Set entries = this.map.entries();
            array = new Context[entries.size()];
            int i = 0;
            for (Map.Entry e : entries) {
                array[i++] = new ContextImpl((String)e.getKey(), (String)e.getValue());
            }
        }
        return array;
    }

    @Override
    public boolean containsKey(@NonNull String key) {
        return this.map.containsKey((Object)MutableContextSetImpl.sanitizeKey(key));
    }

    @Override
    public @NonNull Set<String> getValues(@NonNull String key) {
        Collection values = (Collection)this.map.asMap().get(MutableContextSetImpl.sanitizeKey(key));
        return values != null ? ImmutableSet.copyOf((Collection)values) : ImmutableSet.of();
    }

    @Override
    public boolean contains(@NonNull String key, @NonNull String value) {
        return this.map.containsEntry((Object)MutableContextSetImpl.sanitizeKey(key), (Object)MutableContextSetImpl.sanitizeValue(value));
    }

    @Override
    public @NonNull Iterator<Context> iterator() {
        return Iterators.forArray((Object[])this.toArray());
    }

    @Override
    public Spliterator<Context> spliterator() {
        return Arrays.spliterator(this.toArray());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void add(@NonNull String key, @NonNull String value) {
        if (MutableContextSetImpl.isGlobalServerWorldEntry(key = MutableContextSetImpl.sanitizeKey(key), value = MutableContextSetImpl.sanitizeValue(value))) {
            return;
        }
        this.map.put((Object)key, (Object)value);
    }

    @Override
    public void addAll(@NonNull ContextSet contextSet) {
        Objects.requireNonNull(contextSet, "contextSet");
        this.addAll(contextSet.toSet());
    }

    @Override
    public void remove(@NonNull String key, @NonNull String value) {
        this.map.remove((Object)MutableContextSetImpl.sanitizeKey(key), (Object)MutableContextSetImpl.sanitizeValue(value));
    }

    @Override
    public void removeAll(@NonNull String key) {
        this.map.removeAll((Object)MutableContextSetImpl.sanitizeKey(key));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean otherContainsAll(ContextSet other, ContextSatisfyMode mode) {
        switch (mode) {
            case ALL_VALUES_PER_KEY: {
                Set entries = this.map.entries();
                SetMultimap<String, String> setMultimap = this.map;
                synchronized (setMultimap) {
                    for (Map.Entry e : entries) {
                        if (other.contains((String)e.getKey(), (String)e.getValue())) continue;
                        return false;
                    }
                }
                return true;
            }
            case AT_LEAST_ONE_VALUE_PER_KEY: {
                Set entries = this.map.asMap().entrySet();
                SetMultimap<String, String> setMultimap = this.map;
                synchronized (setMultimap) {
                    for (Map.Entry e : entries) {
                        if (other.containsAny((String)e.getKey(), (Iterable)e.getValue())) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)mode));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet that = (ContextSet)o;
        return this.size() == that.size() && this.otherContainsAll(that, ContextSatisfyMode.ALL_VALUES_PER_KEY);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "MutableContextSet(" + this.map + ")";
    }
}

