/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Paginated;
import me.lucko.luckperms.common.util.Predicates;

public class LogUserHistory
extends ChildCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogUserHistory() {
        super(CommandSpec.LOG_USER_HISTORY, "userhistory", CommandPermission.LOG_USER_HISTORY, Predicates.notInRange(1, 2));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Log log, ArgumentList args, String label) {
        UUID uuid = args.getUserTarget(0, plugin, sender);
        if (uuid == null) {
            return;
        }
        Paginated<LoggedAction> content = new Paginated<LoggedAction>(log.getUserHistory(uuid));
        int page = args.getIntOrDefault(1, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            LogUserHistory.showLog(page, sender, content);
        } else {
            LogUserHistory.showLog(content.getMaxPages(10), sender, content);
        }
    }

    private static void showLog(int page, Sender sender, Paginated<LoggedAction> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender);
            return;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return;
        }
        List<Paginated.Entry<LoggedAction>> entries = log.getPage(page, 10);
        String name = ((LoggedAction)((Paginated.Entry)entries.stream().findAny().get()).value()).getTarget().getName();
        Message.LOG_HISTORY_USER_HEADER.send(sender, name, page, maxPage);
        for (Paginated.Entry<LoggedAction> e : entries) {
            Message.LOG_ENTRY.send(sender, e.position(), e.value());
        }
    }
}

