/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import java.util.List;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.abstraction.ChildCommand;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.node.types.DisplayName;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.DisplayNameNode;

public class GroupSetDisplayName
extends ChildCommand<Group> {
    public GroupSetDisplayName() {
        super(CommandSpec.GROUP_SET_DISPLAY_NAME, "setdisplayname", CommandPermission.GROUP_SET_DISPLAY_NAME, Predicates.is(0));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, Group target, ArgumentList args, String label) throws CommandException {
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, this.getPermission().get(), target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return;
        }
        String name = args.get(0);
        ImmutableContextSet context = args.getContextOrDefault(1, plugin).immutableCopy();
        if (name.isEmpty()) {
            Message.INVALID_DISPLAY_NAME_EMPTY.send(sender);
            return;
        }
        String previousName = target.normalData().nodesInContext(context).stream().filter(NodeType.DISPLAY_NAME::matches).map(NodeType.DISPLAY_NAME::cast).findFirst().map(DisplayNameNode::getDisplayName).orElse(null);
        if (previousName == null && name.equals(target.getName())) {
            Message.GROUP_SET_DISPLAY_NAME_DOESNT_HAVE.send(sender, target.getName());
            return;
        }
        if (name.equals(previousName)) {
            Message.GROUP_SET_DISPLAY_NAME_ALREADY_HAS.send(sender, target.getName(), name);
            return;
        }
        Group existing = plugin.getGroupManager().getByDisplayName(name);
        if (existing != null && !target.equals(existing)) {
            Message.GROUP_SET_DISPLAY_NAME_ALREADY_IN_USE.send(sender, name, existing.getName());
            return;
        }
        target.removeIf(DataType.NORMAL, context, NodeType.DISPLAY_NAME::matches, false);
        if (name.equals(target.getName())) {
            Message.GROUP_SET_DISPLAY_NAME_REMOVED.send(sender, target.getName(), context);
            LoggedAction.build().source(sender).target(target).description("setdisplayname", name, context).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
            return;
        }
        target.setNode(DataType.NORMAL, (Node)((DisplayNameNode.Builder)DisplayName.builder(name).withContext(context)).build(), true);
        Message.GROUP_SET_DISPLAY_NAME.send(sender, name, target.getName(), context);
        LoggedAction.build().source(sender).target(target).description("setdisplayname", name, context).build().submit(plugin, sender);
        StorageAssistant.save(target, sender, plugin);
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().from(1, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

