/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;

public abstract class BufferedRequest<T> {
    private final long bufferTime;
    private final TimeUnit unit;
    private final SchedulerAdapter schedulerAdapter;
    private Processor<T> processor = null;
    private final Object[] mutex = new Object[0];

    public BufferedRequest(long bufferTime, TimeUnit unit, SchedulerAdapter schedulerAdapter) {
        this.bufferTime = bufferTime;
        this.unit = unit;
        this.schedulerAdapter = schedulerAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> request() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            if (this.processor != null) {
                try {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return this.processor.extendAndGetFuture();
                }
                catch (ProcessorAlreadyRanException processorAlreadyRanException) {
                    // empty catch block
                }
            }
            this.processor = new Processor<Object>(this::perform, this.bufferTime, this.unit, this.schedulerAdapter);
            Processor<Object> p = this.processor;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return p.getFuture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Object[] objectArray = this.mutex;
        synchronized (this.mutex) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.processor != null;
        }
    }

    public T requestDirectly() {
        return this.perform();
    }

    protected abstract T perform();

    private static final class Processor<R> {
        private final Supplier<R> supplier;
        private final long delay;
        private final TimeUnit unit;
        private final SchedulerAdapter schedulerAdapter;
        private final Object[] mutex = new Object[0];
        private final CompletableFuture<R> future = new CompletableFuture();
        private boolean usable = true;
        private SchedulerTask scheduledTask;
        private CompletionTask boundTask = null;

        Processor(Supplier<R> supplier, long delay, TimeUnit unit, SchedulerAdapter schedulerAdapter) {
            this.supplier = supplier;
            this.delay = delay;
            this.unit = unit;
            this.schedulerAdapter = schedulerAdapter;
            this.scheduleTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rescheduleTask() throws ProcessorAlreadyRanException {
            Object[] objectArray = this.mutex;
            synchronized (this.mutex) {
                if (!this.usable) {
                    throw new ProcessorAlreadyRanException();
                }
                if (this.scheduledTask != null) {
                    this.scheduledTask.cancel();
                }
                this.scheduleTask();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void scheduleTask() {
            this.boundTask = new CompletionTask();
            try {
                this.scheduledTask = this.schedulerAdapter.asyncLater(this.boundTask, this.delay, this.unit);
            }
            catch (RejectedExecutionException e) {
                this.boundTask.run();
            }
        }

        CompletableFuture<R> getFuture() {
            return this.future;
        }

        CompletableFuture<R> extendAndGetFuture() throws ProcessorAlreadyRanException {
            this.rescheduleTask();
            return this.future;
        }

        private final class CompletionTask
        implements Runnable {
            private CompletionTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object[] objectArray = Processor.this.mutex;
                synchronized (objectArray) {
                    if (!Processor.this.usable) {
                        throw new IllegalStateException("Task has already ran");
                    }
                    if (Processor.this.boundTask != this) {
                        return;
                    }
                    Processor.this.usable = false;
                }
                try {
                    Object result = Processor.this.supplier.get();
                    Processor.this.future.complete(result);
                }
                catch (Exception e) {
                    new RuntimeException("Processor " + Processor.this.supplier + " threw an exception whilst computing a result", e).printStackTrace();
                    Processor.this.future.completeExceptionally(e);
                }
            }
        }
    }

    private static final class ProcessorAlreadyRanException
    extends Exception {
        private ProcessorAlreadyRanException() {
        }
    }
}

