/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.common.bulkupdate.BulkUpdateStatistics;
import me.lucko.luckperms.common.bulkupdate.DataType;
import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.action.Action;
import me.lucko.luckperms.common.bulkupdate.query.Query;
import me.lucko.luckperms.common.model.HolderType;
import net.luckperms.api.node.Node;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BulkUpdate {
    private final DataType dataType;
    private final Action action;
    private final List<Query> queries;
    private final BulkUpdateStatistics statistics = new BulkUpdateStatistics();
    private final boolean trackStatistics;

    public BulkUpdate(DataType dataType, Action action, List<Query> queries, boolean trackStatistics) {
        this.dataType = dataType;
        this.action = action;
        this.queries = queries;
        this.trackStatistics = trackStatistics;
    }

    public boolean satisfiesConstraints(Node node) {
        for (Query query : this.queries) {
            if (query.isSatisfiedBy(node)) continue;
            return false;
        }
        return true;
    }

    private Node apply(Node node) {
        if (!this.satisfiesConstraints(node)) {
            return node;
        }
        Node result = this.action.apply(node);
        if (this.trackStatistics && result != node) {
            this.statistics.incrementAffectedNodes();
        }
        return result;
    }

    public @Nullable Set<Node> apply(Set<Node> nodes, HolderType holderType) {
        HashSet<Node> results = new HashSet<Node>();
        boolean change = false;
        for (Node node : nodes) {
            Node result = this.apply(node);
            if (result != node) {
                change = true;
            }
            if (result == null) continue;
            results.add(result);
        }
        if (!change) {
            return null;
        }
        if (this.trackStatistics) {
            this.statistics.incrementAffected(holderType);
        }
        return results;
    }

    public PreparedStatementBuilder buildAsSql() {
        PreparedStatementBuilder builder = new PreparedStatementBuilder();
        this.action.appendSql(builder);
        return this.appendConstraintsAsSql(builder);
    }

    public PreparedStatementBuilder appendConstraintsAsSql(PreparedStatementBuilder builder) {
        if (this.queries.isEmpty()) {
            return builder;
        }
        builder.append(" WHERE");
        for (int i = 0; i < this.queries.size(); ++i) {
            Query query = this.queries.get(i);
            builder.append(" ");
            if (i != 0) {
                builder.append("AND ");
            }
            query.appendSql(builder);
        }
        return builder;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Action getAction() {
        return this.action;
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public boolean isTrackingStatistics() {
        return this.trackStatistics;
    }

    public BulkUpdateStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkUpdate)) {
            return false;
        }
        BulkUpdate that = (BulkUpdate)o;
        return this.getDataType() == that.getDataType() && Objects.equals(this.getAction(), that.getAction()) && Objects.equals(this.getQueries(), that.getQueries());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDataType(), this.getAction(), this.getQueries(), this.isTrackingStatistics()});
    }

    public String toString() {
        return "BulkUpdate(dataType=" + (Object)((Object)this.getDataType()) + ", action=" + this.getAction() + ", constraints=" + this.getQueries() + ", trackStatistics=" + this.isTrackingStatistics() + ")";
    }
}

