/*
 * Decompiled with CFR 0.152.
 */
package me.drex.vanillapermissions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import java.util.function.Predicate;
import me.drex.vanillapermissions.mixin.CommandNodeAccessor;
import me.drex.vanillapermissions.util.Permission;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPermissionsMod
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "vanilla-permissions";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 MODIFY_VANILLA_PERMISSIONS_PHASE = new class_2960("vanilla-permissions", "modify_vanilla_permissions");

    public void onInitializeServer() {
        CommandRegistrationCallback.EVENT.addPhaseOrdering(MODIFY_VANILLA_PERMISSIONS_PHASE, Event.DEFAULT_PHASE);
        CommandRegistrationCallback.EVENT.register(MODIFY_VANILLA_PERMISSIONS_PHASE, (dispatcher, registryAccess, environment) -> {
            for (CommandNode node : dispatcher.getRoot().getChildren()) {
                this.alterCommandChildNode((CommandDispatcher<class_2168>)dispatcher, (CommandNode<class_2168>)node);
            }
            LOGGER.info("Loaded Fabric Permissions");
        });
    }

    private void alterCommandChildNode(CommandDispatcher<class_2168> dispatcher, CommandNode<class_2168> commandNode) {
        String name = Permission.build(dispatcher.getPath(commandNode).toArray(new String[0]));
        LOGGER.debug("Alter command node {}", (Object)name);
        for (CommandNode child : commandNode.getChildren()) {
            this.alterCommandChildNode(dispatcher, (CommandNode<class_2168>)child);
        }
        ((CommandNodeAccessor)commandNode).setRequirement(this.createPredicate(name, commandNode.getRequirement()));
    }

    private Predicate<class_2168> createPredicate(String name, Predicate<class_2168> fallback) {
        return source -> {
            try {
                TriState triState = Permissions.getPermissionValue((class_2172)source, (String)Permission.COMMAND.formatted(name));
                return triState.orElseGet(() -> fallback.test((class_2168)source));
            }
            catch (Throwable ignored) {
                return fallback.test((class_2168)source);
            }
        };
    }
}

